# -*- coding: UTF-8 -*-

from common.util import util
from common.util import log
import traceback


def execute(devObj):
    '''
    @summary: get device attached disk information
    '''
    try:
        util.initPyDetailMsg(devObj)
        sysDiskNum, diskMap, failedEngins = QueryDiskInfo(devObj)
        if sysDiskNum == 0:
            log.error(devObj, 'Query all disk info failed.')

        if not diskMap:
            diskMap = {}
            log.error(devObj, 'Query all disk info failed.')

        return (diskMap, sysDiskNum, failedEngins)
    except:
        log.error(devObj, "except trace back:%s"
                  % str(traceback.format_exc()))
        return (0, {})


def QueryDiskInfo(devObj):
    '''
    @summary: Query disk information
    '''
    diskMap = {}
    ssh = devObj.get("SSH")
    colltype = "DiskLog"
    action = "query"
    firstField = "node"
    disknum = 0
    scriptFile = "/opt/huawei/snas/bin/datacollect_ModuleEntry.sh"
    cmd = 'sudo %s  "%s" "%s"' % (scriptFile, colltype, action)
    strRet = str((ssh.execCmdWithKeepAlive(cmd, 30, 60 * 10)).encode("utf-8"))

    RetList = strRet.encode("utf-8").splitlines()
    for line in RetList:
        tmplist = []
        tmplist = line.split(',')
        if tmplist[0] == firstField:
            disknum += 1
            nodename = tmplist[1]
            nodeid = tmplist[2]
            slotid = tmplist[3]
            vendor = tmplist[4]
            diskSN = tmplist[5]
            diskType = tmplist[6]
            Model = tmplist[7]
            diskMap[diskSN] = (nodename,
                               nodeid, slotid, vendor, diskSN, diskType, Model)
            log.info(
                devObj,
                "QueryDiskInfo,disknum=%s,nodeid=%s,slotid=%s,"
                "vendor=%s,diskSN=%s,diskType=%s,Model=%s"
                % (disknum, nodeid, slotid, vendor, diskSN, diskType, Model))
        else:
            log.info(devObj, "QueryDiskInfo,no disk info,skip line:%s" % line)
            continue

    if disknum == 0:
        return 0, {}, ''
    else:
        return disknum, diskMap, ''
